%% Sample BUMPTEST Modeling
% offset = 0.125, amp = 0.025, freq = 0.2 Hz
%% Load sample data from MAT files
% load('data_bumptest_q3_wl.mat');
% load('data_bumptest_q3_Im.mat');
%
%% Load variables
t = data_spd(:,1);
wl_meas = data_spd(:,2);
Im = data_Im(:,2);
%
%% Plot response
subplot(2,1,1)
plot(t,wl_meas);
axis([0 0.5 -2.5 1.25*max(wl_meas)]);
ylabel('\omega_l (rad/s)');
subplot(2,1,2)
plot(t,Im);
axis([0 0.5 -0.10 1.5]);
ylabel('I_m (A)');
xlabel('time (s)')
%
%% Find model gain
% Min/max current (A)
Im_min = min(Im);
Im_max = max(Im);
% Time of step (s)
t0 = 0.1;
% Time of recorded speed (s)
t1 = 0.3116;
% Initial velocity (rad/s)
wl_0 = 0;
% Steady-state velocity (rad/s)
wl_1 = 28.0921;
% Input voltage step amplitude (A)
Ac = Im_max - Im_min;
% Experimentally derived steady-state gain (rad/s/V)
Ke_b = (wl_1 - wl_0) / (t1 - t0) / Ac;
%
%
%% Display
disp( 'SRV02 model parameters derived using bumptest: ' )
disp( [ '   Ke_b = ' num2str( Ke_b, 4 ) ' rad/s/A' ] )